/*
 * Decompiled with CFR 0.152.
 */
package com.service.invoice.industrial;

import com.dao.IndustrialInvoiceDao;
import com.dto.InvoiceDetailDto;
import com.dto.industrial.ArticleSarfasl;
import com.utility.DbLogin;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class IndustrialInvoiceService {
    private final IndustrialInvoiceDao dao;
    private final boolean isIndustrial;
    private final List<ArticleSarfasl> invoiceArticlesSarfaslList = new ArrayList();

    public IndustrialInvoiceService(DbLogin dbLogin) {
        this.dao = new IndustrialInvoiceDao(dbLogin);
        this.isIndustrial = this.dao.isIndustrial();
    }

    public void generate_article_sarfasl_of_invoice_articles(List<InvoiceDetailDto> dtlList) throws TncException {
        if (!this.isIndustrial) {
            return;
        }
        try {
            for (InvoiceDetailDto dtl : dtlList) {
                this.invoiceArticlesSarfaslList.add(this.dao.getArticleSarfaslFromInvoiceDtl(dtl));
            }
        }
        catch (DataAccessException ignore) {
            this.invoiceArticlesSarfaslList.clear();
            throw new TncException(TncExceptionMessages.ERROR_WHEN_MAKING_INDUSTRIAL_HEADINGS);
        }
    }

    public boolean isIndustrial() {
        return this.isIndustrial;
    }

    public List<ArticleSarfasl> getInvoiceArticlesSarfaslList() {
        return this.invoiceArticlesSarfaslList;
    }
}

